//
//  MCDNDArrayController.h
//  MCApplication
//
//  Created by Michael Clark on 09/08/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCTableView,BDQualifier;

@interface MCArrayController : NSArrayController {
	NSString*               identifier;

	NSString*               objectClassName;
	NSString*               dndSubsetIdentifier;
	
    IBOutlet MCTableView*   tableView; // weak reference
	
	NSString *searchString;
	NSArray *searchKeypaths; // array of dict with keys "Keypath" and "DisplayString"(for the menu)
	BDQualifier *filterQualifier;
	
	IBOutlet id delegate; // weak reference

	BOOL delegateRespondsToDidAdd;
}


- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (NSString *)objectClassName;
- (void)setObjectClassName:(NSString *)anObjectClassName;

- (NSString *)dndSubsetIdentifier;
- (void)setDndSubsetIdentifier:(NSString *)aDndSubsetIdentifier;

- (MCTableView*)tableView;
- (void)setTableview: (MCTableView*)aTableview;

- (BOOL)canMoveSelectedUp;
- (BOOL)canMoveSelectedDown;

// Search field support
#pragma mark SearchFieldSupport
- (NSString *)searchString;
- (void)setSearchString:(NSString *)aSearchString;
- (NSArray *)searchKeypaths;
- (void)setSearchKeypaths:(NSArray *)aSearchKeypaths;

#pragma mark Accessors
- (void)setDelegate:(id)aDelegate;
- (id)delegate;
- (BDQualifier *)filterQualifier;
- (void)setFilterQualifier:(BDQualifier *)aFilterQualifier;

#pragma mark Actions
- (IBAction)moveSelectedUp:(id)sender;
- (IBAction)moveSelectedDown:(id)sender;
- (IBAction)search:(id)sender;
@end

@interface NSObject (ArrayControllerDelegate)
- (void)arrayController:(MCArrayController *)controller didAddNewObject:(id)newObj;
@end
